////////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) since 1999. VASCO DATA SECURITY
// All rights reserved. http://www.vasco.com
//
////////////////////////////////////////////////////////////////////////////////

/**
 * A crypto application defines a set of characteristics for generating one-time passwords and signatures.
 * Such characteristics include the cryptographic algorithm used (AES, DES, etc), the length of the one-time password or the fact that a challenge can be added.
 * When integrating the Orchestration SDK, you can have up to 8 crypto applications.
 */

NS_REFINED_FOR_SWIFT
typedef enum {
    CryptoAppIndex1 = 1,
    CryptoAppIndex2,
    CryptoAppIndex3,
    CryptoAppIndex4,
    CryptoAppIndex5,
    CryptoAppIndex6,
    CryptoAppIndex7,
    CryptoAppIndex8,
} CryptoAppIndex;
